/* 
 * NeticaCPP.cpp
 *
 * Source file for C++ Development with Netica API, version 4.16 and higher.
 *
 * See file NeticaCPP.h for the header file.
 * For more information, see www.norsys.com
 *
 * Copyright (C) 2000-2010 by Norsys Software Corp.  All rights reserved.
 *
 */

#include "NeticaCPP.h"

namespace netica {


Environ* g_Environ = 0;


Environ::Environ (const char license[], Environ* env, const char locn[]){
	START_NOTHROW_ns
	cenv = NewNeticaEnviron_ns (license, env ? env->cenv : 0, locn);
	cenvloc = env ? env->cenv : cenv;
	g_Environ = this;
	SetEnvironUserData_ns (cenv, 0, this);
	SetLanguage_ns (cenv, "C++");
	char mesg[MESG_LEN_ns];
	int ret = InitNetica2_bn (cenv, mesg);
	if (ret < 0) throw NeticaError (cenv, mesg, 5, ERROR_ERR);
	END_NOTHROW_ns		// cenv may not yet be init, so we cant check for errors yet
	}


}  // namespace netica



